	org 65000

vars:	equ 23627
; (VARS) will show the start of the variables area with A$ defined
; as the first variable and B$ as the second
; (VARS)+6 is the first character of A$
; (VARS)+780 is the first character of B$

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; FIRST ROUTINE - USR 65000 to execute
; the main routine that will convert regular text into Ben Shapiro's
; warp-speed delivery, OK folks...


; set VAR1A and VAR1B
	ld hl,(vars)	; find start of variables area
	ld de,6
	add hl,de	; add 6 to get address of first character of A$
	ex de,hl	; swap HL and DE so that the result is in DE
	ld hl,var1a	; point HL at low byte of VAR1A
	ld (hl),e	; transfer low byte from E
	inc hl		; point HL at high byte of VAR1A
	ld (hl),d	; transfer high byte from D
	ld hl,(vars)	; find start of variables area again
	ld de,780
	add hl,de	; add 780 to get address of first character of B$
	ex de,hl	; swap HL and DE so that the result is in DE
	ld hl,var1b	; point HL at low byte of VAR1B
	ld (hl),e	; transfer low byte from E
	inc hl		; point HL at high byte of VAR1B
	ld (hl),d	; transfer high byte from D
; (VAR1A) will now be the code of the first character of A$	
; (VAR1B) will now be the code of the first character of B$	

; set initial flags - D=3 and E=0.
	ld de,768
	; D is used as a flag to determine if "OKfolks/gang" is required at the end
	; of B$. Bit 0 is set if we need a full stop, bit 1 is set if we need the
	; "OKfolks/gang" as well. Hence D=0 if the last character before CHR$ 31 is a
	; full stop, ? or !. D=1 if the last character if a comma, colon or semicolon
	; and D=3 if it's anything else, which it is set to by default.
	; E is used to keep track of adding "OKfolks" (if E is even) or "OKgang" (if
	; E is odd) - adding 1 each time will cause them to alternate.

; fill first 30 characters of B$ with spaces then an introductory "OKfolks"
	ld hl,(var1b)	; point HL to first character of B$
	call addspcs	; add 30 spaces
	call addok	; add "OKfolks" (because it will be this one this time)

; now translate each character in A$ to its equivalent in B$
; HL is already at the position where the first non-SPACE character of
; B$ will be, so use it to keep track of B$...
	ld ix,(var1a)	; ...and point IX to the first character in A$

compare:
	ld a,(ix+0)	; examine the character of A$
	cp 31		; C will be set if A<31, Z set if A=31
	jr c,nextchar	; skip over this character if A<31
	jr z,finish	; finalise the text if A=31
	cp 32		; Z will be set is A=32
	jr z,nextchar	; skip over this character if A=32
	cp 33		; Z will be set if A=33
	jr z,addokplus	; add "OKfolks", punctuation and space if A=33
	cp 44		; C will be set if A<44, Z set if A=44
	jr c,addchar	; add only the character if A<44 (and A>33)
	jr z,addokminus	; add "OKfolks" if A=44
	cp 45		; Z will be set if A=45
	jr z,addchar	; add only the character if A=45
	cp 46		; Z will be set if A=46
	jr z,addokplus	; add "OKfolks", punctuation and space if A=46
	cp 58		; C will be set if A<58, Z set if A=58
	jr c,addchar	; add only the character if A<58 (and A>46)
	jr z,addokminus	; add "OKfolks" if A=58
	cp 59		; Z will be set if A=59
	jr z,addokminus	; add "OKfolks" if A=59
	cp 63		; C will be set if A<63, Z set if A=63
	jr c,addchar	; add only the character if A<63 (and A>59)
	jr z,addokplus	; add "OKfolks", punctuation and space if A=63
	cp 128		; C will be set if A<128
	jr c,addchar	; add only the character if A<128 (and A>63)
	cp 144		; C will be set if A<144
	jr c,nextchar	; skip over this character if A<144 (and A>127)
	cp 163		; C will be set if A<163
	jr c,addchar	; add only the character if A<163 (and A>143)
	; if A>=163, no need to check - just go to NEXTCHAR which is the next line
	ld d,3		; set D to 3 at this point if we've skipped this far
nextchar:
	inc ix		; move onto next character of A$
	jr compare	; execute routine for next character

finish:			; add "OKfolks/gang", if required, then 30 spaces and CHR$ 31
			; to B$. HL is already in the correct position.
	bit 1,d		; test if D=3. Z flag is RESET if bit 1 is SET.
	jr z,nofinalok	; jump over adding final "OKfolks" if bit 1 is RESET (Z is SET).
	call addok	; add "OKfolks/gang"
nofinalok:
	bit 0,d		; test if D is even (will be 0). Z RESET if bit 0 SET.
	jr z,nofinalpunc	; jump over adding punctuation if bit 0 RESET (Z SET).
	ld (hl),46	; put a full stop into B$
	inc hl		; move position of B$ on by 1
	ld (hl),32	; put an extra dummy space into B$ -
			; now all of the strings end the same way
	inc hl		; move position of B$ on by 1
nofinalpunc:
	dec hl		; delete the extra space in all cases
	call addspcs
	ld (hl),31	; add non-printable character 31 to mark END OF TEXT
	ret


; "JR" SUBROUTINES:

addchar:
	ld (hl),a	; put the character in A into B$
	inc hl		; move position of B$ on by 1
	ld d,3		; set D to 3
	jr nextchar

addokplus:
	call addok	; add "OKfolks/gang" to B$
	ld (hl),a	; put the character in A into B$
	inc hl
	ld (hl),32	; put a space into B$
	inc hl
	ld d,0		; set D to 0 because we already have the final "OKfolks" and
			; punctuation mark.
	jr nextchar

addokminus:
	call addok	; add "OKfolks/gang" to B$	
	ld d,1		; set D to 1 because we have the final "OKfolks" but not the
			; final punctuation mark.
	jr nextchar

; "CALL" SUBROUTINES:

addok:
	ld (hl),79	; add "O" to B$
	inc hl		; move position in B$
	ld (hl),75	; add "K" to B$
	inc hl		; move position in B$
	bit 0,e		; test lowest bit of E, the flag that determines if we're adding
			; "folks" (even) or "gang" (odd). Z is SET if bit0=0 (E is even)
	call z,addfolks	; add "folks" if E is even
	call nz,addgang	; add "gang" if E is odd
	inc e		; flips bit 0 of E to produce the opposite effect next time -
			; the other bits of E are irrelevant
	ret

addfolks:
	ld (hl),102	; add "f" to B$
	inc hl
	ld (hl),111	; add "o" to B$
	inc hl
	ld (hl),108	; add "l" to B$
	inc hl
	ld (hl),107	; add "k" to B$
	inc hl
	ld (hl),115	; add "s" to B$
	inc hl
	ret

addgang:
	ld (hl),103	; add "g" to B$
	inc hl
	ld (hl),97	; add "a" to B$
	inc hl
	ld (hl),110	; add "n" to B$
	inc hl
	ld (hl),103	; add "g" to B$
	inc hl
	ret

addspcs:
	ld b,30
spcloop:
	ld (hl),32	; set character to SPACE
	inc hl		; move to next character
	djnz spcloop
	ret

; VARIABLES:

var1a: defw 0
	; two bytes - holds address of the first character of A$
var1b: defw 0
	; two bytes - holds address of the first character of A$


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; SECOND ROUTINE - USR 65215 to execute
; Prints 30 characters from B$ on screen.
; If the next character after the print is a CHR$ 31, then RET.

; set VAR1B
	ld hl,(vars)	; find start of variables area
	ld de,780
	add hl,de	; add 780 to get address of first character of B$
	ex de,hl	; swap HL and DE so that the result is in DE
	ld hl,var1b	; point HL at low byte of VAR1B
	ld (hl),e	; transfer low byte from E
	inc hl		; point HL at high byte of VAR1B
	ld (hl),d	; transfer high byte from D
; (VAR1B) will now be the code of the first character of B$	

; main screen turn on
	ld a,2
	call 5633	
	ld hl,(var1b)	; point HL at the first character of B$

; repeat this process until the 31st character is CHR$ 31
printmain:
	push hl		; store the intial address in HL on the stack
	ld a,22
	rst 16
	ld a,1
	rst 16
	ld a,1
	rst 16		; PRINT position is set to (1,1)
	; PRINT 30 characters from (HL) to (HL+29)
	ld b,30
printloop:
	ld a,(hl)
	rst 16		; PRINT character and move on the PRINT position
	inc hl		; move on HL as well
	djnz printloop
	; at the end of the loop, HL will be pointing to the 31st character
	ld a,(hl)	; so put it into A to compare
	pop hl		; recover the initial value of HL now in case we need to RET
	cp 31		; looking for CHR$ 31 - Z flag set if A=31
	ret z		; because the POP has already balanced out the PUSH, the stack
			; now contains the reutrn address, so return to BASIC if A=31
	inc hl		; move the restored HL to the next position in B$
	; a very short buzz to give us some sound
	ld b,80
buzzloop:
	ld a,23		; activate the EAR (16) and set the border white (+7)
	out (254),a
	ld a,7		; deactivate the EAR (0) and keep the border white (+7)
	out (254),a
	djnz buzzloop
	; put some delay in here
	ld bc,5120	; a nice, round $1400 in hex
			; slower than the Illuminati II videprinter (3072, $0C00)
delayloop:
	dec bc
	ld a,b
	or c
	jr nz,delayloop
	jr printmain	; after delay, loop back to print again



